package znx.utils;
import java.io.*;

public final class Base64
{
    private static final char[] S_BASE64CHAR;
    private static final char S_BASE64PAD = '=';
    private static final byte[] S_DECODETABLE;

    static {
        S_BASE64CHAR = new char[] { 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/' };
        S_DECODETABLE = new byte[128];
        for (int i = 0; i < Base64.S_DECODETABLE.length; ++i) {
            Base64.S_DECODETABLE[i] = 127;
        }
        for (int i = 0; i < Base64.S_BASE64CHAR.length; ++i) {
            Base64.S_DECODETABLE[Base64.S_BASE64CHAR[i]] = (byte)i;
        }
    }

    private static int decode0(final char[] ibuf, final byte[] obuf, int wp) {
        int outlen = 3;
        if (ibuf[3] == '=') {
            outlen = 2;
        }
        if (ibuf[2] == '=') {
            outlen = 1;
        }
        final int b0 = Base64.S_DECODETABLE[ibuf[0]];
        final int b2 = Base64.S_DECODETABLE[ibuf[1]];
        final int b3 = Base64.S_DECODETABLE[ibuf[2]];
        final int b4 = Base64.S_DECODETABLE[ibuf[3]];
        switch (outlen) {
            case 1: {
                obuf[wp] = (byte)((b0 << 2 & 0xFC) | (b2 >> 4 & 0x3));
                return 1;
            }
            case 2: {
                obuf[wp++] = (byte)((b0 << 2 & 0xFC) | (b2 >> 4 & 0x3));
                obuf[wp] = (byte)((b2 << 4 & 0xF0) | (b3 >> 2 & 0xF));
                return 2;
            }
            default: {
                obuf[wp++] = (byte)((b0 << 2 & 0xFC) | (b2 >> 4 & 0x3));
                obuf[wp++] = (byte)((b2 << 4 & 0xF0) | (b3 >> 2 & 0xF));
                obuf[wp] = (byte)((b3 << 6 & 0xC0) | (b4 & 0x3F));
                return 3;
            }
        }
    }

    public static byte[] decode(final char[] data, final int off, final int len) {
        final char[] ibuf = new char[4];
        int ibufcount = 0;
        final byte[] obuf = new byte[len / 4 * 3 + 3];
        int obufcount = 0;
        for (int i = off; i < off + len; ++i) {
            final char ch = data[i];
            if (ch == '=' || (ch < Base64.S_DECODETABLE.length && Base64.S_DECODETABLE[ch] != 127)) {
                ibuf[ibufcount++] = ch;
                if (ibufcount == ibuf.length) {
                    ibufcount = 0;
                    obufcount += decode0(ibuf, obuf, obufcount);
                }
            }
        }
        if (obufcount == obuf.length) {
            return obuf;
        }
        final byte[] ret = new byte[obufcount];
        System.arraycopy(obuf, 0, ret, 0, obufcount);
        return ret;
    }

    public static byte[] decode(final String data) {
        final char[] ibuf = new char[4];
        int ibufcount = 0;
        final byte[] obuf = new byte[data.length() / 4 * 3 + 3];
        int obufcount = 0;
        for (int i = 0; i < data.length(); ++i) {
            final char ch = data.charAt(i);
            if (ch == '=' || (ch < Base64.S_DECODETABLE.length && Base64.S_DECODETABLE[ch] != 127)) {
                ibuf[ibufcount++] = ch;
                if (ibufcount == ibuf.length) {
                    ibufcount = 0;
                    obufcount += decode0(ibuf, obuf, obufcount);
                }
            }
        }
        if (obufcount == obuf.length) {
            return obuf;
        }
        final byte[] ret = new byte[obufcount];
        System.arraycopy(obuf, 0, ret, 0, obufcount);
        return ret;
    }

    public static void decode(final char[] data, final int off, final int len, final OutputStream ostream) throws IOException {
        final char[] ibuf = new char[4];
        int ibufcount = 0;
        final byte[] obuf = new byte[3];
        for (int i = off; i < off + len; ++i) {
            final char ch = data[i];
            if (ch == '=' || (ch < Base64.S_DECODETABLE.length && Base64.S_DECODETABLE[ch] != 127)) {
                ibuf[ibufcount++] = ch;
                if (ibufcount == ibuf.length) {
                    ibufcount = 0;
                    final int obufcount = decode0(ibuf, obuf, 0);
                    ostream.write(obuf, 0, obufcount);
                }
            }
        }
    }

    public static void decode(final String data, final OutputStream ostream) throws IOException {
        final char[] ibuf = new char[4];
        int ibufcount = 0;
        final byte[] obuf = new byte[3];
        for (int i = 0; i < data.length(); ++i) {
            final char ch = data.charAt(i);
            if (ch == '=' || (ch < Base64.S_DECODETABLE.length && Base64.S_DECODETABLE[ch] != 127)) {
                ibuf[ibufcount++] = ch;
                if (ibufcount == ibuf.length) {
                    ibufcount = 0;
                    final int obufcount = decode0(ibuf, obuf, 0);
                    ostream.write(obuf, 0, obufcount);
                }
            }
        }
    }

    public static String encode(final byte[] data) {
        return encode(data, 0, data.length);
    }

    public static String splitLines(final String bigString, final int lineLength) {
        return bigString.replaceAll("(.{" + lineLength + "})", "$1\n");
    }

    public static String encode(final byte[] data, final int off, final int len) {
        if (len <= 0) {
            return "";
        }
        final char[] out = new char[len / 3 * 4 + 4];
        int rindex = off;
        int windex = 0;
        int rest;
        for (rest = len - off; rest >= 3; rest -= 3) {
            final int i = ((data[rindex] & 0xFF) << 16) + ((data[rindex + 1] & 0xFF) << 8) + (data[rindex + 2] & 0xFF);
            out[windex++] = Base64.S_BASE64CHAR[i >> 18];
            out[windex++] = Base64.S_BASE64CHAR[i >> 12 & 0x3F];
            out[windex++] = Base64.S_BASE64CHAR[i >> 6 & 0x3F];
            out[windex++] = Base64.S_BASE64CHAR[i & 0x3F];
            rindex += 3;
        }
        if (rest == 1) {
            final int i = data[rindex] & 0xFF;
            out[windex++] = Base64.S_BASE64CHAR[i >> 2];
            out[windex++] = Base64.S_BASE64CHAR[i << 4 & 0x3F];
            out[windex++] = '=';
            out[windex++] = '=';
        }
        else if (rest == 2) {
            final int i = ((data[rindex] & 0xFF) << 8) + (data[rindex + 1] & 0xFF);
            out[windex++] = Base64.S_BASE64CHAR[i >> 10];
            out[windex++] = Base64.S_BASE64CHAR[i >> 4 & 0x3F];
            out[windex++] = Base64.S_BASE64CHAR[i << 2 & 0x3F];
            out[windex++] = '=';
        }
        return new String(out, 0, windex);
    }

    public static void encode(final byte[] data, final int off, final int len, final OutputStream ostream) throws IOException {
        if (len <= 0) {
            return;
        }
        final byte[] out = new byte[4];
        int rindex = off;
        int rest;
        for (rest = len - off; rest >= 3; rest -= 3) {
            final int i = ((data[rindex] & 0xFF) << 16) + ((data[rindex + 1] & 0xFF) << 8) + (data[rindex + 2] & 0xFF);
            out[0] = (byte)Base64.S_BASE64CHAR[i >> 18];
            out[1] = (byte)Base64.S_BASE64CHAR[i >> 12 & 0x3F];
            out[2] = (byte)Base64.S_BASE64CHAR[i >> 6 & 0x3F];
            out[3] = (byte)Base64.S_BASE64CHAR[i & 0x3F];
            ostream.write(out, 0, 4);
            rindex += 3;
        }
        if (rest == 1) {
            final int i = data[rindex] & 0xFF;
            out[0] = (byte)Base64.S_BASE64CHAR[i >> 2];
            out[1] = (byte)Base64.S_BASE64CHAR[i << 4 & 0x3F];
            out[3] = (out[2] = 61);
            ostream.write(out, 0, 4);
        }
        else if (rest == 2) {
            final int i = ((data[rindex] & 0xFF) << 8) + (data[rindex + 1] & 0xFF);
            out[0] = (byte)Base64.S_BASE64CHAR[i >> 10];
            out[1] = (byte)Base64.S_BASE64CHAR[i >> 4 & 0x3F];
            out[2] = (byte)Base64.S_BASE64CHAR[i << 2 & 0x3F];
            out[3] = 61;
            ostream.write(out, 0, 4);
        }
    }

    public static void encode(final byte[] data, final int off, final int len, final Writer writer) throws IOException {
        if (len <= 0) {
            return;
        }
        final char[] out = new char[4];
        int rindex = off;
        int rest;
        for (rest = len - off; rest >= 3; rest -= 3) {
            final int i = ((data[rindex] & 0xFF) << 16) + ((data[rindex + 1] & 0xFF) << 8) + (data[rindex + 2] & 0xFF);
            out[0] = Base64.S_BASE64CHAR[i >> 18];
            out[1] = Base64.S_BASE64CHAR[i >> 12 & 0x3F];
            out[2] = Base64.S_BASE64CHAR[i >> 6 & 0x3F];
            out[3] = Base64.S_BASE64CHAR[i & 0x3F];
            writer.write(out, 0, 4);
            rindex += 3;
        }
        if (rest == 1) {
            final int i = data[rindex] & 0xFF;
            out[0] = Base64.S_BASE64CHAR[i >> 2];
            out[1] = Base64.S_BASE64CHAR[i << 4 & 0x3F];
            out[3] = (out[2] = '=');
            writer.write(out, 0, 4);
        }
        else if (rest == 2) {
            final int i = ((data[rindex] & 0xFF) << 8) + (data[rindex + 1] & 0xFF);
            out[0] = Base64.S_BASE64CHAR[i >> 10];
            out[1] = Base64.S_BASE64CHAR[i >> 4 & 0x3F];
            out[2] = Base64.S_BASE64CHAR[i << 2 & 0x3F];
            out[3] = '=';
            writer.write(out, 0, 4);
        }
    }

    public static void encode(final InputStream stream, final long len, final Writer writer) throws IOException {
        if (len <= 0L) {
            return;
        }
        final char[] out = new char[4];
        long rest;
        for (rest = len; rest >= 3L; rest -= 3L) {
            final int i = ((stream.read() & 0xFF) << 16) + ((stream.read() & 0xFF) << 8) + (stream.read() & 0xFF);
            out[0] = Base64.S_BASE64CHAR[i >> 18];
            out[1] = Base64.S_BASE64CHAR[i >> 12 & 0x3F];
            out[2] = Base64.S_BASE64CHAR[i >> 6 & 0x3F];
            out[3] = Base64.S_BASE64CHAR[i & 0x3F];
            writer.write(out, 0, 4);
        }
        if (rest == 1L) {
            final int i = stream.read() & 0xFF;
            out[0] = Base64.S_BASE64CHAR[i >> 2];
            out[1] = Base64.S_BASE64CHAR[i << 4 & 0x3F];
            out[3] = (out[2] = '=');
            writer.write(out, 0, 4);
        }
        else if (rest == 2L) {
            final int i = ((stream.read() & 0xFF) << 8) + (stream.read() & 0xFF);
            out[0] = Base64.S_BASE64CHAR[i >> 10];
            out[1] = Base64.S_BASE64CHAR[i >> 4 & 0x3F];
            out[2] = Base64.S_BASE64CHAR[i << 2 & 0x3F];
            out[3] = '=';
            writer.write(out, 0, 4);
        }
    }
}

